<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage config
* @filesource
*//** */


/*
|--------------------------------------------------------------------------
| File and Directory Modes
|--------------------------------------------------------------------------
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
*/
define('FILE_READ_MODE', 0644);
define('FILE_WRITE_MODE', 0666);
define('DIR_READ_MODE', 0755);
define('DIR_WRITE_MODE', 0777);

/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
*/

define('FOPEN_READ',							'rb');
define('FOPEN_READ_WRITE',						'r+b');
define('FOPEN_WRITE_CREATE_DESTRUCTIVE',		'wb'); // truncates existing file data, use with care
define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE',	'w+b'); // truncates existing file data, use with care
define('FOPEN_WRITE_CREATE',					'ab');
define('FOPEN_READ_WRITE_CREATE',				'a+b');
define('FOPEN_WRITE_CREATE_STRICT',				'xb');
define('FOPEN_READ_WRITE_CREATE_STRICT',		'x+b');

/*
|--------------------------------------------------------------------------
| Application Settings
|--------------------------------------------------------------------------
|
| These are used to configure application constants
|
*/

define('DIRECT_ATTACHMENT_SIZE_LIMIT', '10485760'); //in bytes
define('ITEMS_PER_PAGE_DEFAULT','10'); //must be one of the values defined in application\third_party\Paginator\display_items_per_page:$ipp_array
define('PAGINATION_MID_RANGE','9');
define('MAX_MESSAGES','100');
define('SEND_DISPLAY_MDN',TRUE);

/*
|--------------------------------------------------------------------------
| Application Security Settings
|--------------------------------------------------------------------------
|
| These are used to configure application security related constants
|
*/

define('USE_CAC_AUTH',FALSE);
define('USE_PIV_AUTH',TRUE);
define('IS_AJAX', isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest');

//Used to configure constants that changed based on environment
define('DIRECT_ENVIRONMENT', 'PROD');	
switch(DIRECT_ENVIRONMENT) {

	case 'PROD':
		define('ENVIRONMENT_TIMEZONE','America/New_York'); //environment default time zone
		define('DIRECT_DOMAIN', 'direct.domain');
		define('API_DOMAIN', 'api.'.DIRECT_DOMAIN);
		define('API_ADMINPANEL_DOMAIN', 'developer.'.DIRECT_DOMAIN);
		define('GATEWAY_SMTP_HOSTNAME',	'vadirappprd11.aac.domain');
		define('GATEWAY_HOSTNAME','vadirappprd11.aac.domain');
		define('GATEWAY_SMTP_PORT',		'25');
		define('GATEWAY_EXTERNAL_EMAIL_PORT', '587');
		define('EMAIL_SIGNATURE', 'VLER Direct Team');
		define('EXTERNAL_EMAILS_FROM', 'notifications@'.DIRECT_DOMAIN);
		define('GATEWAY_SMTP_TIMEOUT', '1');
		define('DIRECT_SEND_PROTOCOL', 'smtp');
		define('DATABASE_HOSTNAME', 'your_server200.aac.dva.domain\your_server200,1433');
		define('DATABASE_NAME', 'api');
		define('MAIL_DATABASE_NAME', 'mail');
		define('DATABASE_USERNAME', 'api-db');
		define('DATABASE_PASSWORD', '');
		define('DATABASE_DRIVER', 'sqlsrv');
		define('LDAP_HOSTNAME', 'vadirappprd10.aac.domain');
		define('LDAP_PORT', '389');
		define('LDAP_BASE_RDN', 'dc=api,dc=direct,dc=va,dc=gov');
		define('LDAP_API_ADMIN_GROUP', 'ou=api_admins,'.LDAP_BASE_RDN);
		define('LDAP_APPLICATION_GROUP', 'ou=applications,'.LDAP_BASE_RDN);
		define('LDAP_DISABLED_APPLICATION_GROUP', 'ou=disabled_applications,'.LDAP_BASE_RDN);
		define('LDAP_DIRECT_API_PERMISSIONS_GROUP', 'ou=direct_api_apps,'.LDAP_BASE_RDN);
		define('LDAP_ADMIN_API_PERMISSIONS_GROUP', 'ou=admin_api_apps,'.LDAP_BASE_RDN);
		define('LDAP_DISCLOSURE_API_PERMISSIONS_GROUP', 'ou=disclosure_api_apps,'.LDAP_BASE_RDN);
		define('LDAP_APPLICATION_ADMIN_GROUP_NAME', 'admins');
		define('LDAP_APPLICATION_USER_GROUP_NAME', 'users');
		define('LDAP_ACCOUNT_GROUP', 'ou=accounts,'.LDAP_BASE_RDN);
		define('LDAP_DISABLED_ACCOUNT_GROUP', 'ou=disabled_accounts,'.LDAP_BASE_RDN);
		define('LDAP_ROLES_GROUP', 'ou=roles,'.LDAP_BASE_RDN);
		define('LDAP_GROUPS_GROUP', 'ou=groups,'.LDAP_BASE_RDN);
		define('LDAP_DISABLED_GROUPS_GROUP', 'ou=disabled_groups,'.LDAP_BASE_RDN);
		define('LDAP_ANON_SEARCH_USERNAME', 'cn=webmailsearch,dc=direct,dc=va,dc=gov');
		define('LDAP_ANON_SEARCH_PASSWORD', '');
		define('LDAP_ANON_ADMIN_USERNAME', 'cn=admin,dc=direct,dc=va,dc=gov');
		define('LDAP_ANON_ADMIN_PASSWORD', '');
		define('WEBSERVICE_URL', 'http://'.API_DOMAIN);
		define('WEBSERVICE_PUBLIC_KEY', '');
		define('WEBSERVICE_PRIVATE_KEY', ''); 
		define('PRODUCT_NAME', 'Direct Secure Messaging API');
		define('WKHTMLTOPDF_EXE_PATH', 'C:\Program Files (x86)\wkhtmltopdf\wkhtmltopdf.exe');
		define('WARNING_BANNER_TITLE', 'VA Notice and Consent Banner');
		define('WARNING_BANNER_PAGE_TITLE', 'Direct API: VA Notice and Consent');
		define('WARNING_BANNER', '<p>VA systems are intended to be used by authorized VA network users for viewing and retrieving information only except as otherwise explicitly authorized for official business and limited personal use under VA policy.</p>
								<p>
									Information from this system resides on and transmits through computer systems and networks funded by the VA.
									All access or use constitutes understanding and acceptance that there is no reasonable expectation of privacy in the use of Government networks or systems.
								</p>
								<p>All access or use of this system constitutes user understanding and acceptance of these terms and constitutes unconditional consent to review and action including (but not limited to) monitoring recording copying auditing inspecting investigating restricting access blocking  tracking disclosing to authorized personnel or any other authorized actions by all authorized VA and law enforcement personnel.</p>
								Unauthorized user attempts or acts to
								<ul style="list-style-type: none;">
								<li>(1) access upload download change or delete information on this system</li>
								<li>(2) modify this system</li>  
								<li>(3) deny access to this system</li>
								<li>(4) accrue resources for unauthorized use or</li> 
								<li>(5) otherwise misuse this system are strictly prohibited.</li>
								</ul>
								<p>Such attempts or acts are subject to action that may result in criminal civil or administrative penalties.</p>');
		break;

}

/**#@-*/
/* End of file constants.php */
/* Location: ./application/config/constants.php */
